// Inject "Send to Suno" buttons on MusicMaker's generate page.
// Runs as a Chrome extension content script so it has access to chrome.storage.

function addSunoButtons() {
  // Add buttons inside expanded history detail panels
  document.querySelectorAll('.track-detail').forEach(detail => {
    if (detail.querySelector('.suno-btn')) return;

    const btn = document.createElement('button');
    btn.className = 'suno-btn';
    btn.textContent = '>> SEND TO SUNO >>';
    btn.style.cssText =
      'margin-top:8px;padding:4px 10px;border:2px outset #fff;background:#c0c0c0;' +
      'font-size:10px;font-weight:bold;cursor:pointer;color:#660066;display:block;';
    btn.addEventListener('click', (e) => {
      e.stopPropagation();
      sendToSuno(
        detail.dataset.title || '',
        detail.dataset.style || '',
        detail.dataset.lyrics || ''
      );
    });
    detail.appendChild(btn);
  });

  // Add button after the live output box when it has content
  const output = document.getElementById('output');
  if (output && output.classList.contains('visible') && output.textContent.trim()) {
    if (!document.getElementById('suno-output-btn')) {
      const btn = document.createElement('button');
      btn.id = 'suno-output-btn';
      btn.className = 'btn95';
      btn.textContent = '>> SEND TO SUNO >>';
      btn.style.cssText = 'margin-top:8px;color:#660066;';
      btn.addEventListener('click', () => {
        // Parse title/style/lyrics from raw output text
        const raw = output.textContent;
        const parsed = parseRawOutput(raw);
        sendToSuno(parsed.title, parsed.style, parsed.lyrics);
      });
      output.parentNode.insertBefore(btn, output.nextSibling);
    }
  } else {
    const existing = document.getElementById('suno-output-btn');
    if (existing) existing.remove();
  }
}

function parseRawOutput(text) {
  let title = '', style = '', lyrics = text;
  const lines = text.split('\n');
  let lyricsStart = 0;

  for (let i = 0; i < lines.length; i++) {
    const line = lines[i].trim();
    if (line.toUpperCase().startsWith('TITLE:')) {
      title = line.slice(6).trim();
    } else if (line.toUpperCase().startsWith('STYLE:')) {
      style = line.slice(6).trim();
      for (let j = i + 1; j < lines.length; j++) {
        if (lines[j].trim() === '') { lyricsStart = j + 1; break; }
      }
      if (!lyricsStart) lyricsStart = i + 1;
      break;
    }
  }

  if (lyricsStart) lyrics = lines.slice(lyricsStart).join('\n').trim();
  return { title, style, lyrics };
}

function sendToSuno(title, style, lyrics) {
  chrome.storage.local.set(
    { suno_transfer: { title, style, lyrics, ts: Date.now() } },
    () => window.open('https://suno.com/create', '_blank')
  );
}

addSunoButtons();
new MutationObserver(addSunoButtons).observe(document.body, { childList: true, subtree: true });
